#ifndef __CVstMidiEventList__
#define __CVstMidiEventList__

#include <audioeffectx.h>
#include <Midi/CMidiEventList.hpp>
using Exponent::Midi::CMidiEventList;

//	===========================================================================

namespace Exponent
{
	namespace Vst
	{
		/**
		 * @class CVstMidiEventList CVstMidiEventList.hpp
		 * @brief Midi event list with specialist functionality for VST interaction
		 *
		 * @date 15/04/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @see Exponent::Midi::CMidiEventList
		 * @note Parent class in the EMusic library
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 * Please note that VST is copyright Steinberg Media GmBh. No challenge is made to any of their trademarks
		 * To use this file, you require a copy of the VST SDK, available from www.steinberg.net for free
		 *
		 * $Id: CVstMidiEventList.hpp,v 1.3 2007/02/08 21:08:23 paul Exp $
		 */
		class CVstMidiEventList : public CMidiEventList
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 */
			CVstMidiEventList();

			/**
			 * Destruction
			 */
			virtual ~CVstMidiEventList();

//	===========================================================================

			/**
			 * Set midi from VST buffer
			 * @param events The VST events
			 */
			void addFromVSTEvent(VstEvents *events);

//	===========================================================================

		};
	}
}
#endif	// End of CVstMidiEventList.hpp